<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BankController;

Route::get('/', function () {
    return view('home');
})->name('home');

Route::get('/send-money', function () {
    return view('send-money');
})->name('send-money');

Route::get('/about', function () {
    return view('about');
})->name('about');

Route::get('/help', function () {
    return view('help');
})->name('help');

Route::get('/privacy', function () {
    return view('privacy');
})->name('privacy');

Route::get('/terms', function () {
    return view('terms');
})->name('terms');

Route::get('/contact', function () {
    return view('contact');
})->name('contact');

Route::get('/signup', function () {
    return view('signup');
})->name('signup');

// Bank API Routes
Route::prefix('api')->group(function () {
    Route::get('/countries/search', [BankController::class, 'searchCountries']);
    Route::get('/payout-types/{country}', [BankController::class, 'getPayoutTypes']);
    Route::get('/banks', [BankController::class, 'getBanks']);
});
