<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Home Remitt')</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Red+Hat+Display:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVJkEZSMUkrQ6usKnu8D48E8sBmCQrB7MCavNE+88sCG5FB7HeYdV5PTflwzxMZn6in5Z7xOOmA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        body {
            background-color: #0a1628;
            color: #FFFFFF;
        }
        
        /* Hamburger Menu Styles */
        .hamburger {
            display: flex;
            flex-direction: column;
            cursor: pointer;
            width: 24px;
            height: 24px;
            justify-content: space-between;
        }
        
        .hamburger span {
            display: block;
            width: 100%;
            height: 2px;
            background-color: #FFFFFF;
            border-radius: 2px;
            transition: all 0.3s ease;
        }
        
        .hamburger.active span:nth-child(1) {
            transform: rotate(45deg) translate(8px, 8px);
        }
        
        .hamburger.active span:nth-child(2) {
            opacity: 0;
        }
        
        .hamburger.active span:nth-child(3) {
            transform: rotate(-45deg) translate(7px, -7px);
        }
        
        /* Mobile Menu */
        .mobile-menu {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.9);
            z-index: 40;
            padding-top: 100px;
        }
        
        .mobile-menu.active {
            display: flex;
            flex-direction: column;
        }
        
        .mobile-menu a, .mobile-menu button {
            color: #FFFFFF;
            padding: 16px 24px;
            font-size: 16px;
            border: none;
            background: none;
            text-align: left;
            cursor: pointer;
            transition: background-color 0.2s ease;
        }
        
        .mobile-menu a:hover, .mobile-menu button:hover {
            background-color: rgba(34, 211, 238, 0.1);
        }
        
        .mobile-menu .submenu {
            display: none;
            padding-left: 24px;
        }
        
        .mobile-menu .submenu.active {
            display: flex;
            flex-direction: column;
        }
        
        .mobile-menu .submenu a {
            padding: 12px 24px;
            font-size: 14px;
            color: #cccccc;
        }
        
        .mobile-menu .submenu a:hover {
            color: #FFFFFF;
        }
    </style>
    @stack('styles')
</head>
<body class="antialiased">
    <!-- Header / Navbar -->
    <header class="absolute -top-8 left-0 right-0 z-50 py-0">
        <nav class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 flex items-center">
            <!-- Logo -->
            <a href="/" class="flex items-center">
                <img src="{{ asset('images/logo_new.png') }}" alt="Home Remitt" class="h-32 w-auto object-contain">
            </a>

            <!-- Navigation Links -->
            <div class="hidden lg:flex items-center space-x-8 ml-8">
                <a href="{{ route('home') }}" class="@if(request()->routeIs('home')) text-white font-medium @else text-gray-300 @endif hover:text-white transition text-sm">Home</a>
                <a href="{{ route('send-money') }}" class="@if(request()->routeIs('send-money')) text-white font-medium @else text-gray-300 @endif hover:text-white transition text-sm">Send Money</a>
                <a href="{{ route('about') }}" class="@if(request()->routeIs('about')) text-white font-medium @else text-gray-300 @endif hover:text-white transition text-sm">About Us</a>
                <a href="{{ route('help') }}" class="@if(request()->routeIs('help')) text-white font-medium @else text-gray-300 @endif hover:text-white transition text-sm">Help</a>
                
                <!-- More Dropdown -->
                <div class="relative group">
                    <button class="@if(request()->routeIs('privacy') || request()->routeIs('terms') || request()->routeIs('contact') || request()->routeIs('signup')) text-white font-medium @else text-gray-300 @endif hover:text-white transition text-sm flex items-center space-x-1">
                        <span>More</span>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" /></svg>
                    </button>
                    <!-- Dropdown Menu -->
                    <div class="absolute left-0 mt-0 w-48 bg-gray-900 rounded-lg shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200">
                        <a href="{{ route('contact') }}" class="block px-4 py-2 @if(request()->routeIs('contact')) bg-cyan-600 text-white font-medium @else text-gray-300 hover:text-white hover:bg-gray-800 @endif transition text-sm rounded-t-lg">Contact Us</a>
                        <a href="{{ route('signup') }}" class="block px-4 py-2 @if(request()->routeIs('signup')) bg-cyan-600 text-white font-medium @else text-gray-300 hover:text-white hover:bg-gray-800 @endif transition text-sm">Sign Up</a>
                        <a href="{{ route('privacy') }}" class="block px-4 py-2 @if(request()->routeIs('privacy')) bg-cyan-600 text-white font-medium @else text-gray-300 hover:text-white hover:bg-gray-800 @endif transition text-sm">Privacy Policy</a>
                        <a href="{{ route('terms') }}" class="block px-4 py-2 @if(request()->routeIs('terms')) bg-cyan-600 text-white font-medium @else text-gray-300 hover:text-white hover:bg-gray-800 @endif transition text-sm rounded-b-lg">Terms and Conditions</a>
                    </div>
                </div>
            </div>

            <!-- Right Side -->
            <div class="ml-auto flex items-center space-x-4">
                <button class="flex items-center space-x-2 px-3 py-2 rounded-full bg-white/10 hover:bg-white/20 transition">
                    <div class="w-8 h-8 rounded-full overflow-hidden flex items-center justify-center flex-shrink-0">
                        <img src="{{ asset('images/sa.png') }}" alt="South Africa Flag" class="w-full h-full object-cover">
                    </div>
                </button>
                <a href="#" class="hidden sm:inline-block px-5 py-2 rounded-lg bg-cyan-500 hover:bg-cyan-600 text-white font-medium transition shadow-lg text-sm">Download App</a>
                
                <!-- Hamburger Menu Button (Mobile) -->
                <button id="hamburger" class="lg:hidden hamburger">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
            </div>
        </nav>
        
        <!-- Mobile Menu -->
        <div id="mobile-menu" class="mobile-menu">
            <a href="{{ route('home') }}" class="@if(request()->routeIs('home')) bg-cyan-600 @endif">Home</a>
            <a href="{{ route('send-money') }}" class="@if(request()->routeIs('send-money')) bg-cyan-600 @endif">Send Money</a>
            <a href="{{ route('about') }}" class="@if(request()->routeIs('about')) bg-cyan-600 @endif">About Us</a>
            <a href="{{ route('help') }}" class="@if(request()->routeIs('help')) bg-cyan-600 @endif">Help</a>
            
            <!-- More Submenu -->
            <button class="more-menu-btn" style="display: flex; justify-content: space-between; align-items: center;">
                <span>More</span>
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" /></svg>
            </button>
            <div class="submenu">
                <a href="{{ route('contact') }}" class="@if(request()->routeIs('contact')) bg-cyan-600 @endif">Contact Us</a>
                <a href="{{ route('signup') }}" class="@if(request()->routeIs('signup')) bg-cyan-600 @endif">Sign Up</a>
                <a href="{{ route('privacy') }}" class="@if(request()->routeIs('privacy')) bg-cyan-600 @endif">Privacy Policy</a>
                <a href="{{ route('terms') }}" class="@if(request()->routeIs('terms')) bg-cyan-600 @endif">Terms and Conditions</a>
            </div>
        </div>
    </header>
    </header>

    <!-- Main Content -->
    <main>
        @yield('content')
    </main>

    @stack('scripts')
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.getElementById('hamburger');
            const mobileMenu = document.getElementById('mobile-menu');
            const moreMenuBtn = document.querySelector('.more-menu-btn');
            const submenu = document.querySelector('.submenu');
            
            // Toggle hamburger menu
            hamburger.addEventListener('click', function() {
                hamburger.classList.toggle('active');
                mobileMenu.classList.toggle('active');
            });
            
            // Toggle submenu in mobile menu
            if (moreMenuBtn) {
                moreMenuBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    submenu.classList.toggle('active');
                    const svg = moreMenuBtn.querySelector('svg');
                    svg.style.transform = submenu.classList.contains('active') ? 'rotate(180deg)' : 'rotate(0deg)';
                });
            }
            
            // Close menu when a link is clicked
            const mobileMenuLinks = mobileMenu.querySelectorAll('a');
            mobileMenuLinks.forEach(link => {
                link.addEventListener('click', function() {
                    hamburger.classList.remove('active');
                    mobileMenu.classList.remove('active');
                    if (submenu && submenu.classList.contains('active')) {
                        submenu.classList.remove('active');
                    }
                });
            });
        });
    </script>
</body>
</html>
