@extends('layouts.app')

@section('title', 'Home Remitt - Send Money Efficiently')

    @push('styles')
    <style>
        body {
            background-color: #070F2B; /* Brand Dark Blue */
            color: #FFFFFF;
            overflow-x: hidden;
        }
        
        /* Custom Utiliti    <!-- Features Section -->
    <section class="py-2 relative z-10 bg-[#031528]"> */
        .text-cyan-brand {                    <!-- Right Content: Phone Mockup Composition -->
                <div class="relative flex justify-center lg:justify-end">
                    <!-- Container for positioning -->
                    <div class="relative w-full max-w-[450px] h-[800px] flex justify-center items-center">         <!-- Right Content: Phone Mockup C    <!-- Mobile CTA Card with Image (Mobile only) -->
    <section class="lg:hidden py-8 px-4 sm:px-6 bg-white">
        <div class="container mx-auto max-w-sm">
            <div class="relative bg-gradient-to-b from-[#0a0e27] via-[#0f1829] to-[#1a2d42] rounded-3xl overflow-hidden shadow-lg h-[700px]">
                <!-- Background Image with Gradient -->
                <div class="absolute inset-0">
                    <img src="/images/design161.png" alt="Family using Home Remitt" class="absolute bottom-0 left-0 right-0 w-full h-[320px] object-contain translate-y-9">
                    <div class="absolute inset-0 bg-gradient-to-b from-[#0a0e27]/95 via-[#0f1829]/75 to-[#1a2d42]/40"></div>
                </div>n -->
                <div class="relative flex justify-center lg:justify-end lg:col-span-1">
                    <!-- Container for positioning -->
                    <div class="relative w-full max-w-[600px] h-[800px] flex justify-center items-center">r: #22d3ee; }
        .bg-cyan-brand { background-color: #22d3ee; }
        .hover-bg-cyan-brand:hover { background-color: #06b6d4; }
        
        /* Gradient Text */
        .text-gradient-orange-cyan {
            background: linear-gradient(90deg, #FFB300 0%, #FF8C00 40%, #FF6347 60%, #00BCD4 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .text-gradient-cyan {
            background: linear-gradient(90deg, #0d8fa3 0%, #0d8fa3 50%, #000000 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }        /* Backgrounds */
        .hero-bg {
            background-image: url('/images/banner1.jpg');
            background-size: cover;
            background-position: center center;
        }
        
        .calculator-card {
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
        }

        /* Steps Vertical Line */
        .step-connector::before {
            content: '';
            position: absolute;
            top: 2rem;
            left: 1rem;
            bottom: -2rem;
            width: 2px;
            background-color: #374151; /* Gray-700 */
            z-index: 0;
        }
        .step-item:last-child .step-connector::before {
            display: none;
        }

        /* Stats Background */
        .stats-bg {
            background-image: url('https://placehold.co/1600x600/0f172a/1e293b?text=World+Map+Pattern');
            background-size: cover;
            background-position: center;
            background-blend-mode: overlay;
        }

        /* Globe positioning for proper curve display */
        .globe-container {
            position: absolute;
            top: -150px;
            left: 50%;
            transform: translateX(-50%);
            width: 120vw;
            max-width: none;
            z-index: 0;
            overflow: visible;
        }
        
        .globe-container img {
            width: 100%;
            height: auto;
            object-fit: contain;
            opacity: 0.8;
            display: block;
            margin: 0 auto;
        }
        
        @media (max-width: 1200px) {
            .globe-container {
                top: -120px;
                width: 140vw;
            }
        }
        
        @media (max-width: 768px) {
            .globe-container {
                top: -100px;
                width: 160vw;
            }
        }
        
        @media (max-width: 480px) {
            .globe-container {
                top: -80px;
                width: 180vw;
            }
        }

        /* Form Elements */
        .input-group-text {
            display: flex;
            align-items: center;
            padding: 0.375rem 0.75rem;
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
            color: #212529;
            text-align: center;
            white-space: nowrap;
            background-color: #e9ecef;
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
        }

        /* Gradient Fade Blocks Background */
        .gradient-fade-blocks {
            position: relative;
            overflow: hidden;
        }

        .gradient-fade-blocks::after {
            content: '';
            position: absolute;
            bottom: 0;
            right: 0;
            width: 600px;
            height: 600px;
            background: linear-gradient(135deg, transparent 0%, rgba(34, 211, 238, 0.08) 25%, rgba(34, 211, 238, 0.12) 50%, transparent 100%);
            pointer-events: none;
            z-index: 1;
        }

        .gradient-fade-blocks::before {
            content: '';
            position: absolute;
            bottom: 0;
            right: 0;
            width: 500px;
            height: 500px;
            background-image: 
                linear-gradient(0deg, rgba(200, 200, 200, 0.3) 1px, transparent 1px),
                linear-gradient(90deg, rgba(200, 200, 200, 0.3) 1px, transparent 1px);
            background-size: 40px 40px;
            background-position: bottom right;
            -webkit-mask-image: radial-gradient(circle at bottom right, black 0%, transparent 70%);
            mask-image: radial-gradient(circle at bottom right, black 0%, transparent 70%);
            pointer-events: none;
            z-index: 1;
        }

        .gradient-fade-blocks > * {
            position: relative;
            z-index: 2;
        }

        /* CTA Section Background */
        .cta-section {
            background: linear-gradient(135deg, #0a1929 0%, #1a2844 50%, #0d3b4c 100%);
        }
    </style>
@endpush

@section('content')

    <!-- Hero Section -->
    <section class="relative pt-20 pb-24 overflow-visible bg-[#031528]">
        <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            
            <!-- Top Row: Banner Image + Calculator -->
            <div class="relative mb-10">
                <!-- Banner Image -->
                <div class="relative w-full rounded-2xl overflow-hidden">
                    <img src="/images/banner1.jpg" alt="Family" class="w-full h-64 sm:h-80 lg:h-96 object-cover rounded-2xl" style="object-position: center 30%;">
                </div>
                
                <!-- Calculator Widget (overlaps on desktop) -->
                <div class="w-full sm:w-96 mx-auto lg:w-[500px] lg:absolute lg:right-12 lg:top-40 lg:mx-0 px-4 -mt-4 sm:-mt-6 lg:mt-0">
                    <div class="bg-white rounded-2xl p-6 shadow-2xl relative z-10">
                        <div class="mb-5 text-center">
                            <h3 class="text-lg font-bold" style="color: #072538; font-family: 'Red Hat Display', sans-serif;">More for your family.</h3>
                            <p class="text-xs text-gray-500 mt-1" style="color: #072538; font-family: 'Red Hat Display', sans-serif;">We make sure more of your money goes to those you love, not to high service fees</p>
                        </div>

                        <!-- Tabs -->
                        <div class="mb-5">
                            <p class="text-xs mb-2" style="color: #072538;">Payout Method</p>
                            <div class="flex space-x-2">
                                <button class="px-3 py-2 text-xs font-medium rounded-md text-white flex-1 text-center" style="background-color: #072538;">Bank Transfer</button>
                                <button class="px-3 py-2 text-xs font-medium rounded-md bg-gray-100 text-gray-600 hover:bg-gray-200 flex-1 text-center">Mobile Wallet</button>
                                <button class="px-3 py-2 text-xs font-medium rounded-md bg-gray-100 text-gray-600 hover:bg-gray-200 flex-1 text-center">Cash Pickup</button>
                            </div>
                        </div>

                        <!-- You Send -->
                        <div class="mb-4">
                            <div class="relative flex flex-col border border-gray-200 rounded-lg bg-gray-50 p-3">
                                <label class="block text-xs mb-2" style="color: #072538;">You send</label>
                                <div class="relative flex items-center">
                                    <input type="number" value="800" class="block w-full text-xl font-bold text-gray-900 bg-transparent outline-none [&::-webkit-outer-spin-button]:hidden [&::-webkit-inner-spin-button]:hidden" placeholder="0.00" style="appearance: textfield;">
                                    <div class="absolute right-0 flex items-center mr-3">
                                        <div class="flex items-center space-x-2 px-3 py-1">
                                            <div class="w-px h-5 bg-gray-300"></div>
                                            <div class="w-6 h-6 rounded-full overflow-hidden flex items-center justify-center flex-shrink-0">
                                                <img src="{{ asset('images/sa.png') }}" class="w-full h-full object-cover">
                                            </div>
                                            <span class="font-medium text-gray-900 text-sm">ZAR</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- They Receive -->
                        <div class="mb-4">
                            <div class="relative flex flex-col border border-gray-200 rounded-lg bg-gray-50 p-3">
                                <label class="block text-xs mb-2" style="color: #072538;">They receive</label>
                                <div class="relative flex items-center">
                                    <input type="text" value="18,694.12" readonly class="block w-full text-xl font-bold text-gray-900 bg-transparent outline-none">
                                    <div class="absolute right-0 flex items-center">
                                        <button class="flex items-center space-x-2 px-3 py-1">
                                            <div class="w-px h-5 bg-gray-300"></div>
                                            <img src="{{ asset('images/pk.png') }}" class="object-cover rounded-sm">
                                            <span class="font-medium text-gray-900 text-sm">PKR</span>
                                            <svg class="w-4 h-4 text-gray-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" /></svg>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Exchange Rate -->
                        <div class="flex justify-between text-sm mb-5 px-3 py-2 rounded-lg bg-gray-50">
                            <span class="text-gray-600">Exchange Rate</span>
                            <span class="font-medium text-gray-900">$23.50</span>
                        </div>

                        <div class="flex justify-end">
                            <button class="px-8 text-white font-semibold py-3 rounded-lg transition" style="background-color: #072538; hover:background-color: #051d2a;">
                                Transfer
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bottom Row: Text Content -->
            <div class="w-full mt-8">
                <h1 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-white leading-tight">
                    <span class="text-gradient-orange-cyan">Send Money</span>
                </h1>
                <h2 class="text-2xl sm:text-3xl lg:text-4xl font-bold text-white mt-1">
                    Efficiently with Home Remitt
                </h2>
                <p class="mt-4 text-sm sm:text-base text-gray-300 max-w-lg leading-relaxed">
                    Send money efficiently and securely to over <span class="text-white font-medium">30 countries</span> with convenient payout methods – no hidden fees, just reliable transfers you can trust.
                </p>
                
                <div class="mt-6 flex flex-wrap gap-3">
                    <a href="#" class="inline-block hover:opacity-80 transition">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Google Play" class="h-12">
                    </a>
                    <a href="#" class="inline-block hover:opacity-80 transition">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/3/3c/Download_on_the_App_Store_Badge.svg" alt="App Store" class="h-12">
                    </a>
                    <div class="w-full"></div>
                    <a href="#" class="inline-block hover:opacity-80 transition overflow-visible">
                        <img src="/images/appgallery.png" alt="AppGallery" class="h-11 w-auto">
                    </a>
                </div>
            </div>

        </div>
    </section>

    <!-- Features Section -->
    <section class="py-0 -mt-20 relative z-10 bg-[#031528]">
        <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <div class="mb-16">
                <span class="text-gray-300 font-semibold tracking-widest uppercase text-xs">Why Choose Us</span>
                <h2 class="text-2xl md:text-3xl text-white mt-4">Finally, The Best Way To Send<br>Money Home</h2>
                <p class="text-gray-300 mt-4 text-base">Experience seamless financial transactions with our<br>online money transfer service</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Card 1 -->
                <div class="bg-[#072538] p-8 rounded-2xl hover:bg-[#0A3347] transition duration-300 group">
                    <div class="w-14 h-14 mb-6">
                        <img src="/images/fi_13652522.png" alt="Affordable">
                    </div>
                    <h3 class="text-xl font-bold text-white mb-3" style="font-family: 'Red Hat Display', sans-serif;">Affordable</h3>
                    <p class="text-white leading-relaxed" style="font-family: 'Red Hat Display', sans-serif;">
                        Affordable service that helps you send more to those who matter.
                    </p>
                </div>

                <!-- Card 2 -->
                <div class="bg-[#072538] p-8 rounded-2xl hover:bg-[#0A3347] transition duration-300 group">
                    <div class="w-14 h-14 mb-6">
                        <img src="/images/fi_3759086.png" alt="Efficient" class=object-contain">
                    </div>
                    <h3 class="text-xl font-bold text-white mb-3" style="font-family: 'Red Hat Display', sans-serif;">Efficient</h3>
                    <p class="text-white leading-relaxed" style="font-family: 'Red Hat Display', sans-serif;">
                        Efficient service designed to get your hard-earned money to those who matter most, when they need it.
                    </p>
                </div>

                <!-- Card 3 -->
                <div class="bg-[#072538] p-8 rounded-2xl hover:bg-[#0A3347] transition duration-300 group">
                    <div class="w-14 h-14 mb-6">
                        <img src="/images/fi_11250429.png" alt="Secure">
                    </div>
                    <h3 class="text-xl font-bold text-white mb-3" style="font-family: 'Red Hat Display', sans-serif;">Secure</h3>
                    <p class="text-white leading-relaxed" style="font-family: 'Red Hat Display', sans-serif;">
                        Trusted transfers keep your money and your peace of mind protected every step of the way.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- How It Works (4 Easy Steps) -->
    <section class="py-20 bg-white">
        <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <!-- Header -->
            <div class="mb-8">
                <p class="text-xs font-semibold uppercase tracking-wider mb-2" style="color: #072538;">GET TRANSACTING</p>
                <h2 class="text-3xl md:text-4xl"><span class="text-[#0d8fa3]">4</span> <span class="text-gradient-cyan">easy steps</span></h2>
                <p class="mt-3 text-sm max-w-md" style="color: #313131;">Smart and Effortless ways to send money home, Securely and Efficiently. All you need is a South African Mobile Number to get started!</p>
                <a href="#" class="inline-block mt-6 text-white font-semibold px-6 py-3 rounded-lg transition text-sm" style="background-color: #00B5C5;" onmouseover="this.style.backgroundColor='#0095a3'" onmouseout="this.style.backgroundColor='#00B5C5'">Download App</a>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 items-start mt-12">
                <!-- Left Content: Steps -->
                <div class="space-y-4">
                    <!-- Step 1 -->
                    <div class="border-2 border-[#22B8B0] rounded-xl p-6 shadow-sm">
                        <h3 class="text-base font-bold text-gray-900 flex items-center">
                            <span class="text-[#22B8B0] mr-2 font-bold text-lg">1</span> Choose Beneficiary
                        </h3>
                        <p class="text-gray-600 mt-2 text-sm leading-relaxed">Add your beneficiary details, select the country and choose a payout method and point.</p>
                    </div>

                    <!-- Step 2 -->
                    <div class="bg-white border border-gray-200 rounded-xl p-6 shadow-sm">
                        <h3 class="text-base font-normal text-gray-900 flex items-center">
                            <span class="text-black mr-2 font-bold text-lg">2</span> Create Transaction
                        </h3>
                        <p class="text-gray-600 mt-2 text-sm leading-relaxed">Select your beneficiary and tell us how much you want to send.</p>
                    </div>

                    <!-- Step 3 -->
                    <div class="bg-white border border-gray-200 rounded-xl p-6 shadow-sm">
                        <h3 class="text-base font-normal text-gray-900 flex items-center">
                            <span class="text-black mr-2 font-bold text-lg">3</span> Make payment
                        </h3>
                        <p class="text-gray-600 mt-2 text-sm leading-relaxed">Provide the reference number that you have received and pay for your transaction using any of our approved pay-in methods.</p>
                    </div>

                    <!-- Step 4 -->
                    <div class="bg-white border border-gray-200 rounded-xl p-6 shadow-sm">
                        <h3 class="text-base font-normal text-gray-900 flex items-center">
                            <span class="text-black mr-2 font-bold text-lg">4</span> Money collection
                        </h3>
                        <p class="text-gray-600 mt-2 text-sm leading-relaxed">Once the full payment for your transaction has been received, the transferred amount is immediately available for your beneficiary to collect.</p>
                    </div>
                </div>

                <!-- Right Content: Phone Mockup Composition -->
                <div class="relative flex justify-center lg:justify-end lg:-mr-12 xl:-mr-20 lg:-mt-16 xl:-mt-20">
                    <!-- Container for positioning -->
                    <div class="relative w-full max-w-[400px] lg:max-w-[500px] h-[700px] lg:h-[800px] flex justify-center lg:justify-end items-center lg:items-start lg:pt-8 xl:pt-4 lg:translate-x-16 xl:translate-x-24">
                        
                        <!-- Top-right decorative blur circle -->
                        <div class="absolute -top-16 -right-8 lg:right-0 xl:right-4 z-5 w-40 h-40 rounded-full bg-gray-200/30 blur-3xl"></div>
                        
                        <!-- Bottom-right decorative blur circle -->
                        <div class="absolute -bottom-12 -right-4 lg:right-0 xl:right-8 z-5 w-48 h-48 rounded-full bg-gray-200/20 blur-3xl"></div>
                        
                        <!-- Main phone UI - positioned to the far right -->
                        
                        <!-- Bottom decorative blur circle (lighter) -->
                        <div class="absolute -bottom-20 left-0 lg:left-2 xl:left-4 z-5 w-32 h-32 rounded-full bg-gray-200/15 blur-2xl"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Section Footer Image (contains Connecting Families text and app store badges) -->
        <div class="w-full" style="margin-top: -45rem;">
            <img src="/images/1707483747.png" alt="Connecting families, one transfer at a time" class="w-full h-auto">
        </div>
    </section>

    <!-- Stats Section -->
    <section class="py-20 relative bg-[#031528] overflow-hidden" style="background-image: url('/images/vector.png'); background-size: cover; background-position: center;">
        
        <!-- Globe Image - Positioned to show full curved earth -->
        <div class="globe-container z-0">
            <img src="/images/11383028.png" alt="Globe" class="w-full h-auto object-contain opacity-80">
        </div>
        
        <div class="container relative z-20 mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            
            <!-- Main Content -->
            <div class="text-center pt-64 lg:pt-72 xl:pt-80 relative z-30">
                <!-- Header Text -->
                <p class="text-white font-semibold uppercase tracking-wider text-sm mb-4" style="font-family: 'Red Hat Display', sans-serif;">CONNECTING THE WORLD</p>
                <h2 class="text-4xl md:text-5xl lg:text-6xl text-white mb-6" style="font-family: 'Red Hat Display', sans-serif;">Bringing loved ones closer, Worldwide</h2>
                <p class="text-gray-300 text-lg max-w-3xl mx-auto mb-16" style="font-family: 'Red Hat Display', sans-serif;">Send money anytime, the efficient and affordable way, to over 30 countries around the world.</p>
                
                <!-- Stats Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-16 mb-16 max-w-4xl mx-auto">
                    <div class="text-center">
                        <div class="text-gray-300 font-medium text-lg mb-4">Customers serviced</div>
                        <div class="text-6xl md:text-7xl text-red-500">2,341,199</div>
                    </div>
                    <div class="text-center">
                        <div class="text-gray-300 font-medium text-lg mb-4">Transfer Completed</div>
                        <div class="text-6xl md:text-7xl text-orange-400">10,790,988</div>
                    </div>
                </div>
                
                <!-- App Store Badges -->
                <div class="flex justify-center gap-6 mb-24">
                    <a href="#" class="inline-block hover:opacity-80 transition">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Google Play" class="h-12">
                    </a>
                    <a href="#" class="inline-block hover:opacity-80 transition">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/3/3c/Download_on_the_App_Store_Badge.svg" alt="App Store" class="h-12">
                    </a>
                    <a href="#" class="inline-block hover:opacity-80 transition">
                        <img src="/images/appgallery.png" alt="AppGallery" class="h-12 w-auto">
                    </a>
                </div>
            </div>
            
            <!-- Countries Supported Section -->
            <div class="text-center mt-20 relative z-50">
                    <h3 class="text-3xl md:text-4xl text-white mb-4">Countries supported</h3>
                    <p class="text-white-300 mb-12">We serve over 30 countries around the world</p>
                
                    <!-- Region Tabs -->
                    <div class="flex justify-center mb-16">
                        <div class="flex bg-gray-800/50 rounded-lg p-1">
                            <button class="px-8 py-3 rounded-md bg-cyan-500 text-white font-semibold">Asia</button>
                            <button class="px-8 py-3 rounded-md text-gray-400 font-semibold hover:text-white">Europe</button>
                            <button class="px-8 py-3 rounded-md text-gray-400 font-semibold hover:text-white">North America</button>
                            <button class="px-8 py-3 rounded-md text-gray-400 font-semibold hover:text-white">South America</button>
                        </div>
                    </div>
                    
                    <!-- Country Flags Grid -->
                    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-8 gap-4 max-w-6xl mx-auto">
                        <!-- Bangladesh -->
                        <div class="bg-[#0F1F35] rounded-lg p-4 text-center hover:bg-[#1A2F47] transition">
                            <img src="https://flagcdn.com/w80/bd.png" alt="Bangladesh Flag" class="w-16 h-10 mx-auto mb-3 rounded object-cover">
                            <p class="text-gray-400 text-xs mb-1">Send money to</p>
                            <p class="text-white font-medium text-sm">Bangladesh</p>
                        </div>
                        
                        <!-- Pakistan -->
                        <div class="bg-[#0F1F35] rounded-lg p-4 text-center hover:bg-[#1A2F47] transition">
                            <img src="https://flagcdn.com/w80/pk.png" alt="Pakistan Flag" class="w-16 h-10 mx-auto mb-3 rounded object-cover">
                            <p class="text-gray-400 text-xs mb-1">Send money to</p>
                            <p class="text-white font-medium text-sm">Pakistan</p>
                        </div>
                        
                        <!-- India -->
                        <div class="bg-[#0F1F35] rounded-lg p-4 text-center hover:bg-[#1A2F47] transition">
                            <img src="https://flagcdn.com/w80/in.png" alt="India Flag" class="w-16 h-10 mx-auto mb-3 rounded object-cover">
                            <p class="text-gray-400 text-xs mb-1">Send money to</p>
                            <p class="text-white font-medium text-sm">India</p>
                        </div>
                        
                        <!-- Afghanistan -->
                        <div class="bg-[#0F1F35] rounded-lg p-4 text-center hover:bg-[#1A2F47] transition">
                            <img src="https://flagcdn.com/w80/af.png" alt="Afghanistan Flag" class="w-16 h-10 mx-auto mb-3 rounded object-cover">
                            <p class="text-gray-400 text-xs mb-1">Send money to</p>
                            <p class="text-white font-medium text-sm">Afghanistan</p>
                        </div>
                        
                        <!-- UAE -->
                        <div class="bg-[#0F1F35] rounded-lg p-4 text-center hover:bg-[#1A2F47] transition">
                            <img src="https://flagcdn.com/w80/ae.png" alt="UAE Flag" class="w-16 h-10 mx-auto mb-3 rounded object-cover">
                            <p class="text-gray-400 text-xs mb-1">Send money to</p>
                            <p class="text-white font-medium text-sm">UAE</p>
                        </div>
                        
                        <!-- Thailand -->
                        <div class="bg-[#0F1F35] rounded-lg p-4 text-center hover:bg-[#1A2F47] transition">
                            <img src="https://flagcdn.com/w80/th.png" alt="Thailand Flag" class="w-16 h-10 mx-auto mb-3 rounded object-cover">
                            <p class="text-gray-400 text-xs mb-1">Send money to</p>
                            <p class="text-white font-medium text-sm">Thailand</p>
                        </div>
                        
                        <!-- China -->
                        <div class="bg-[#0F1F35] rounded-lg p-4 text-center hover:bg-[#1A2F47] transition">
                            <img src="https://flagcdn.com/w80/cn.png" alt="China Flag" class="w-16 h-10 mx-auto mb-3 rounded object-cover">
                            <p class="text-gray-400 text-xs mb-1">Send money to</p>
                            <p class="text-white font-medium text-sm">China</p>
                        </div>
                        
                        <!-- Sri Lanka -->
                        <div class="bg-[#0F1F35] rounded-lg p-4 text-center hover:bg-[#1A2F47] transition">
                            <img src="https://flagcdn.com/w80/lk.png" alt="Sri Lanka Flag" class="w-16 h-10 mx-auto mb-3 rounded object-cover">
                            <p class="text-gray-400 text-xs mb-1">Send money to</p>
                            <p class="text-white font-medium text-sm">Sri Lanka</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials -->
    <section class="py-20 bg-[#F5F5F7]">
        <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Left: Heading and Total Rating -->
                <div>
                    <p class="font-semibold uppercase tracking-wider text-sm mb-2" style="color: #072538;">Testimonial</p>
                    <h2 class="text-4xl md:text-5xl font-bold text-gradient-cyan mb-4">Loved by our customers</h2>
                    <p class="text-sm mb-8" style="color: #313131;">Real life stories, by those that love us.</p>
                    
                    <div class="grid grid-cols-2 gap-8 md:gap-12">
                        <!-- Rating Box 1 -->
                        <div class="flex flex-col items-start">
                            <div class="text-gray-900" style="font-family: 'Red Hat Display', sans-serif; font-weight: 700; font-size: 90px; line-height: 120%; letter-spacing: -2px;">+120</div>
                            <p class="text-gray-700 font-medium text-sm md:text-base mt-3" style="font-size: 18px;">Total Reviews</p>
                        </div>
                        
                        <!-- Rating Box 2 -->
                        <div class="flex flex-col items-start">
                            <div class="flex items-center space-x-0" style="letter-spacing: -2px;">
                                <span class="text-gray-900" style="font-family: 'Red Hat Display', sans-serif; font-weight: 700; font-size: 90px; line-height: 120%; letter-spacing: -2px;">★</span>
                                <span class="text-gray-900" style="font-family: 'Red Hat Display', sans-serif; font-weight: 700; font-size: 90px; line-height: 120%; letter-spacing: -2px;">4.9</span>
                            </div>
                            <p class="text-gray-700 font-medium text-sm md:text-base mt-3" style="font-size: 18px;">Rated on Appstore</p>
                        </div>
                    </div>
                </div>

                <!-- Right: Specific Review Card -->
                <div>
                    <img src="/images/design151.png" alt="Testimonial Card" class="w-full rounded-3xl">
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="py-20 bg-[#F5F5F7]">
        <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <div class="mb-12 flex justify-between items-start">
                <div>
                    <p class="font-semibold uppercase tracking-wider text-xs mb-3" style="color: #072538; font-family: 'Red Hat Display', sans-serif;">Any Question?</p>
                    <h2 class="text-2xl font-bold text-gradient-cyan mb-4">Frequently Asked Questions</h2>
                    <p class="text-gray-700 font-medium">Still have any questions? Contact our team via our <a href="/contact" class="text-cyan-500 font-semibold underline hover:text-cyan-600 transition">contact us</a> page</p>
                </div>
                <a href="#" class="font-semibold hover:opacity-80 whitespace-nowrap ml-4 flex items-center gap-2" style="color: #072538; font-family: 'Red Hat Display', sans-serif;">See All <i class="fas fa-chevron-right text-sm"></i></a>
            </div>

            <div class="space-y-3">
                <!-- FAQ Item 1 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" data-faq="1">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Who is Home Remitt?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">−</span>
                    </div>
                    <p class="mt-3 faq-answer" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">We are a technology-enabled, fully-regulated money transfer service that allows individuals to send money to various international countries.</p>
                </div>
                
                <!-- FAQ Item 2 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" data-faq="2">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Is Home Remitt regulated?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <p class="mt-3 faq-answer hidden" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">Yes, Home Remitt is fully regulated and complies with all international financial regulations and standards.</p>
                </div>
                
                <!-- FAQ Item 3 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" data-faq="3">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Why should I join the Home Remitt family?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <p class="mt-3 faq-answer hidden" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">We offer competitive rates, low fees, fast transfers, and a secure platform that ensures your money reaches your loved ones safely and quickly.</p>
                </div>
                
                <!-- FAQ Item 4 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" data-faq="4">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Where is Home Remitt based?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <p class="mt-3 faq-answer hidden" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">Home Remitt is based in South Africa and operates as a licensed money transfer service provider.</p>
                </div>
                
                <!-- FAQ Item 5 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" data-faq="5">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">How do I contact Home Remitt for assistance?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <p class="mt-3 faq-answer hidden" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">You can contact our support team via email, phone, or through our website contact form. Visit our contact page for all available options.</p>
                </div>
            </div>

            <script>
                document.querySelectorAll('.faq-item').forEach(item => {
                    item.addEventListener('click', function() {
                        const icon = this.querySelector('.faq-icon');
                        const answer = this.querySelector('.faq-answer');
                        
                        // Toggle the answer visibility
                        answer.classList.toggle('hidden');
                        
                        // Toggle between plus and minus
                        if (icon.textContent === '+') {
                            icon.textContent = '−';
                        } else {
                            icon.textContent = '+';
                        }
                    });
                });
            </script>
        </div>
    </section>

    <!-- Call to Action Section -->
    @include('components.cta-section')

    <!-- Main Footer -->
    @include('components.shared-footer')

    <!-- Interactive Scripts for Preview -->
    <script>
        // Simple Tab Logic for Calculator
        const tabs = document.querySelectorAll('.calculator-card button');
        tabs.forEach(tab => {
            tab.addEventListener('click', (e) => {
                if(e.target.innerText.match(/Bank|Wallet|Cash/)) {
                    // Reset styling for all tabs in this group
                    e.target.parentElement.querySelectorAll('button').forEach(b => {
                        b.classList.remove('bg-white', 'text-blue-900', 'shadow-sm');
                        b.classList.add('text-gray-500');
                    });
                    // Active style
                    e.target.classList.remove('text-gray-500');
                    e.target.classList.add('bg-white', 'text-blue-900', 'shadow-sm');
                }
            });
        });

        // FAQ Toggles
        const faqItems = document.querySelectorAll('.bg-\\[\\#1B274B\\]');
        faqItems.forEach(item => {
            item.addEventListener('click', () => {
                // In a real app, this would toggle visibility of the answer
                // For this preview, we'll just toggle the icon
                const icon = item.querySelector('.fas');
                if (icon.classList.contains('fa-plus')) {
                    icon.classList.remove('fa-plus');
                    icon.classList.add('fa-minus');
                    item.style.backgroundColor = '#233058';
                } else {
                    icon.classList.remove('fa-minus');
                    icon.classList.add('fa-plus');
                    item.style.backgroundColor = '';
                }
            });
        });
    </script>
</body>
@endsection

@push('scripts')
<script>
    // Basic tab switching logic
    document.addEventListener('DOMContentLoaded', function() {
        const tabContainer = document.getElementById('payout-tabs');
        if (tabContainer) {
            const tabs = tabContainer.querySelectorAll('.tab-btn');
            
            tabs.forEach(tab => {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    // Remove active class from all tabs
                    tabs.forEach(t => t.classList.remove('active'));
                    
                    // Add active class to clicked tab
                    this.classList.add('active');
                    
                    // In a real app, you would now
                    // update the calculator based on the data-tab attribute
                    // console.log('Selected tab:', this.dataset.tab);
                });
            });
        }
    });
</script>
@endpush