@extends('layouts.app')

@section('title', 'Contact Us - Home Remitt')

@push('styles')
<link rel="stylesheet" href="{{ asset('css/shared-styles.css') }}">
<style>
    .contact-input {
        background-color: #1B274B;
        border: 1px solid #2d3748;
        color: white;
        transition: all 0.3s ease;
    }
    .contact-input:focus {
        border-color: #22d3ee;
        outline: none;
        background-color: #233058;
    }
    .info-card {
        background-color: #1B274B;
        transition: transform 0.3s;
    }
    .info-card:hover {
        transform: translateY(-5px);
    }
</style>
@endpush

@section('content')

<!-- Hero Banner (Matches PDF Header style) -->
<section class="relative pt-32 pb-16 bg-[#0B1435]">
    <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 flex flex-col md:flex-row items-center justify-between">
        <div class="md:w-1/2 mb-10 md:mb-0">
            <h1 class="text-4xl md:text-5xl font-bold mb-4 leading-tight">
                An affordable, efficient<br>and secure way to<br>send money home.
            </h1>
            <p class="text-gray-400 mb-8 text-lg">Sign up and save on your next transfer</p>
            <a href="#" class="inline-block bg-cyan-500 hover:bg-cyan-600 text-white font-bold py-3 px-8 rounded-lg transition shadow-lg">
                Download App
            </a>
        </div>
        <div class="md:w-1/2 relative">
            <div class="absolute inset-0 bg-cyan-500 blur-3xl opacity-10 rounded-full"></div>
            <!-- Placeholder for Family Image in Header -->
            <img src="https://placehold.co/600x400/1a202c/FFF?text=Family+Moment" alt="Family" class="relative rounded-2xl shadow-2xl z-10 w-full object-cover border border-gray-700">
        </div>
    </div>
</section>

<!-- Contact Form & Info Section -->
<section class="py-20 bg-[#070F2B]">
    <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        
        <!-- Intro Text -->
        <div class="text-center mb-16 max-w-3xl mx-auto">
            <span class="text-cyan-400 font-bold uppercase tracking-wider text-sm">Contact Us</span>
            <h2 class="text-3xl font-bold text-white mt-3 mb-6">We're here to help.</h2>
            <p class="text-gray-300 leading-relaxed">
                Home Remitt makes sending money from South Africa to your loved ones abroad affordable, efficient and secure. If you have questions or need support, our team is here to assist you every step of the way.
            </p>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">
            
            <!-- Left Column: Contact Form -->
            <div class="lg:col-span-2">
                <div class="bg-[#1B274B] p-8 rounded-2xl shadow-xl border border-gray-800">
                    <h3 class="text-xl font-bold text-white mb-6">Send us a Message</h3>
                    <form action="#" method="POST" class="space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm text-gray-400 mb-2">Name</label>
                                <input type="text" placeholder="Enter your name" class="w-full px-4 py-3 rounded-lg contact-input">
                            </div>
                            <div>
                                <label class="block text-sm text-gray-400 mb-2">Email</label>
                                <input type="email" placeholder="Enter your email" class="w-full px-4 py-3 rounded-lg contact-input">
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">Phone Number</label>
                            <input type="tel" placeholder="Enter your phone number" class="w-full px-4 py-3 rounded-lg contact-input">
                        </div>
                        
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">Message</label>
                            <textarea rows="5" placeholder="Your Message..." class="w-full px-4 py-3 rounded-lg contact-input resize-none"></textarea>
                        </div>
                        
                        <div class="text-right">
                            <button type="button" class="bg-cyan-500 hover:bg-cyan-600 text-white font-bold py-3 px-8 rounded-lg transition shadow-lg">
                                Send Message
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Right Column: Info Cards -->
            <div class="space-y-6">
                <!-- Location Card -->
                <div class="info-card p-8 rounded-2xl border border-gray-800 flex flex-col items-center text-center">
                    <div class="w-16 h-16 bg-blue-600/20 text-blue-400 rounded-full flex items-center justify-center text-2xl mb-4">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <h4 class="text-lg font-bold text-white mb-2">Location</h4>
                    <p class="text-gray-400 text-sm leading-relaxed">
                        Riviera Road Office Park<br>
                        6-10 Riviera Road Riviera,<br>
                        Killarney, Johannesburg, 2193
                    </p>
                </div>

                <!-- Call Us Card -->
                <div class="info-card p-8 rounded-2xl border border-gray-800 flex flex-col items-center text-center">
                    <div class="w-16 h-16 bg-green-600/20 text-green-400 rounded-full flex items-center justify-center text-2xl mb-4">
                        <i class="fas fa-phone-alt"></i>
                    </div>
                    <h4 class="text-lg font-bold text-white mb-2">Call Us</h4>
                    <p class="text-cyan-400 text-xl font-bold">064 303 0300</p>
                    <p class="text-gray-500 text-xs mt-2">Mon - Fri, 8am - 5pm</p>
                </div>

                <!-- Email Card (Optional addition for completeness) -->
                <div class="info-card p-8 rounded-2xl border border-gray-800 flex flex-col items-center text-center">
                    <div class="w-16 h-16 bg-purple-600/20 text-purple-400 rounded-full flex items-center justify-center text-2xl mb-4">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <h4 class="text-lg font-bold text-white mb-2">Email Us</h4>
                    <p class="text-gray-400 text-sm">hello@homeremitt.com</p>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- Footer -->
@include('components.shared-footer')

@endsection