<!-- Shared Footer Component (matching home.blade.php) -->
<footer class="bg-[#031528] py-8 lg:pt-16 lg:pb-8 border-t border-gray-800">
    <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        <!-- Footer Content -->
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-12 mb-12">
            <!-- Left Col: Logo and App Badges -->
            <div class="col-span-1 lg:col-span-3">
                <div class="mb-0 lg:mb-2">
                    <img src="{{ asset('images/logo_new.png') }}" alt="Home Remitt" class="h-40 w-auto object-contain mb-0 lg:mb-2">
                </div>
                <!-- App Store Badges -->
                <div class="flex flex-wrap gap-3">
                    <a href="#" class="inline-block hover:opacity-80 transition">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Google Play" class="h-10">
                    </a>
                    <a href="#" class="inline-block hover:opacity-80 transition">
                        <img src="https://upload.wikimedia.org/wikipedia/commons/3/3c/Download_on_the_App_Store_Badge.svg" alt="App Store" class="h-10">
                    </a>
                </div>
                <div class="mt-3">
                    <a href="#" class="inline-block hover:opacity-80 transition">
                        <img src="/images/appgallery.png" alt="AppGallery" class="h-10">
                    </a>
                </div>
            </div>

            <!-- Right Cols: Links (2-column on all screens) -->
            <div class="col-span-1 lg:col-span-9">
                <div class="grid grid-cols-2 gap-8">
                    <!-- Links Col 1 -->
                    <div>
                        <ul class="space-y-3 text-sm text-white">
                            <li><a href="#" class="hover:text-cyan-400 transition">Send Money</a></li>
                            <li><a href="#" class="hover:text-cyan-400 transition">Pay in points</a></li>
                            <li><a href="#" class="hover:text-cyan-400 transition">About Us</a></li>
                            <li><a href="#" class="hover:text-cyan-400 transition">Help</a></li>
                        </ul>
                    </div>

                    <!-- Links Col 2 -->
                    <div>
                        <ul class="space-y-3 text-sm text-white">
                            <li><a href="#" class="hover:text-cyan-400 transition">FAQs</a></li>
                            <li><a href="#" class="hover:text-cyan-400 transition">Tracking payments</a></li>
                            <li><a href="#" class="hover:text-cyan-400 transition">Contact us</a></li>
                            <li><a href="#" class="hover:text-cyan-400 transition">Terms & conditions</a></li>
                            <li><a href="#" class="hover:text-cyan-400 transition">Privacy policy</a></li>
                            <li><a href="#" class="hover:text-cyan-400 transition">Loyalty Program</a></li>
                        </ul>
                    </div>

                    <!-- Whatsapp Contact Info -->
                    <div class="col-span-2 mt-4">
                        <ul class="space-y-3 text-sm text-white">
                            <li><a href="#" class="hover:text-cyan-400 transition">Whatsapp</a></li>
                            <li>064 303 0300</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="pt-8">
            <p class="text-white text-xs">© 2025 Home Remitt. All rights reserved.</p>
        </div>
    </div>
</footer>

