@extends('layouts.app')

@section('title', 'About Us - Home Remitt')

@push('styles')
<style>
    body {
        background-color: #FFFFFF;
        color: #1F2937;
    }

    /* Navigation styling for About page */
    header nav a {
        color: #000000;
    }

    header nav a:hover {
        color: #666666;
    }

    /* Hamburger menu color */
    .hamburger span {
        background-color: #000000 !important;
    }

    /* Site name/branding text color */
    header .text-white {
        color: #000000;
    }

    header .text-gray-300 {
        color: #666666;
    }

    /* Navigation dropdown */
    header .group-hover\:opacity-100 {
        background-color: #F3F4F6;
    }

    header .group-hover\:opacity-100 a {
        color: #1F2937;
    }

    /* Download button on nav */
    header .bg-cyan-500 {
        background-color: #0891b2;
    }

    /* Country selector button */
    header .bg-white\/10 {
        background-color: rgba(0, 0, 0, 0.1);
    }

    .text-gradient {
        background: linear-gradient(90deg, #22d3ee 0%, #3b82f6 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }
    .value-card {
        background-color: #1B274B;
        transition: transform 0.3s ease, background-color 0.3s ease;
    }
    .value-card:hover {
        transform: translateY(-5px);
        background-color: #233058;
    }
</style>
@endpush

@section('content')

<!-- Hero Section -->
<section class="relative pt-20 pb-20 overflow-hidden bg-gradient-to-b from-white via-white to-slate-50">
    <div class="container mx-auto max-w-4xl px-4 sm:px-6 lg:px-8">
        <div class="flex flex-col items-start">
            <!-- Content -->
            <div class="mb-12 w-full">
                <h1 class="text-5xl md:text-6xl mb-6">
                    <span class="font-bold bg-gradient-to-r from-orange-400 to-amber-900 bg-clip-text text-transparent">About</span> <span class="text-gray-900">Home Remitt</span>
                </h1>
                <p class="text-lg text-gray-700 leading-relaxed max-w-2xl">
                    Empowering cross-border communities with affordable, efficient, and secure money transfers. Because everyone deserves access to financial freedom.
                </p>
            </div>

            <!-- App Store Badges -->
            <div class="mt-6 flex flex-wrap gap-3 mb-16">
                <a href="#" class="inline-block hover:opacity-80 transition">
                    <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Google Play" class="h-12">
                </a>
                <a href="#" class="inline-block hover:opacity-80 transition">
                    <img src="https://upload.wikimedia.org/wikipedia/commons/3/3c/Download_on_the_App_Store_Badge.svg" alt="App Store" class="h-12">
                </a>
                <div class="w-full"></div>
                <a href="#" class="inline-block hover:opacity-80 transition overflow-visible">
                    <img src="/images/appgallery.png" alt="AppGallery" class="h-11 w-auto">
                </a>
            </div>

            <!-- Image -->
            <div class="w-full flex justify-center -mt-8">
                <div class="relative w-full max-w-md">
                    <!-- Container with set height for proper layout -->
                    <div class="relative w-full pt-[100%]">
                        <!-- Background Image (family photo) -->
                        <img src="/images/aboutus2.png" alt="Home Remitt Family" class="absolute inset-0 w-full h-full object-cover z-10 scale-150">
                        <!-- Front Decorative Image (centered and positioned higher) -->
                        <img src="/images/aboutus.png" alt="Decorative Design" class="absolute top-20 left-1/2 transform -translate-x-1/2 z-20 w-full h-full object-contain">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Our Story, Purpose & Mission Section -->
<section class="py-16 bg-white">
    <div class="container mx-auto max-w-3xl px-4 sm:px-6 lg:px-8">
        <!-- Main Card -->
        <div class="bg-[#031528] p-8 sm:p-12 rounded-3xl border border-cyan-500/20">
            
            <!-- Our Story -->
            <div class="mb-12">
                <h2 class="text-3xl sm:text-4xl font-light text-white text-center mb-8">Our Story</h2>
                <div class="space-y-4 text-gray-200 leading-relaxed text-center text-sm sm:text-base">
                    <p>
                        Home Remitt was born in 2020 when two South African friends saw a shared opportunity, not just to build a FinTech, but to transform lives.
                    </p>
                    <p>
                        They witnessed the struggles of migrants and unbanked communities: high fees, slow transfers, and exclusion from traditional finance. So, they created a solution rooted in affordable, efficient and secure transfers.
                    </p>
                    <p>
                        Today, we're more than a remittance service, we're a bridge between families, futures, and financial freedom. Every transfer is powered by cutting-edge technology, designed with care, and driven by a simple promise: to make sending money home affordable, efficient, and secure.
                    </p>
                </div>
            </div>

            <!-- Our Purpose -->
            <div class="mb-12 bg-[#0A1F35] p-8 rounded-2xl">
                <div class="flex flex-col items-start">
                    <img src="/images/heart.png" alt="Heart" class="w-16 h-16 mb-4">
                    <h3 class="text-2xl font-light text-white mb-2">Our Purpose</h3>
                    <p class="text-gray-300 text-sm leading-relaxed">
                        Enriching and improving the lives of our hardworking customers globally. We don't just move money, we strengthen families and fuel dreams.
                    </p>
                </div>
            </div>

            <!-- Our Mission -->
            <div class="bg-[#0A1F35] p-8 rounded-2xl">
                <div class="flex flex-col items-start">
                    <img src="/images/globe.png" alt="Globe" class="w-16 h-16 mb-4">
                    <h3 class="text-2xl font-light text-white mb-2">Our Mission</h3>
                    <p class="text-gray-300 text-sm leading-relaxed">
                        We empower hardworking individuals worldwide by providing the fastest, most affordable way to send money home. United as one, we lead with authenticity, innovate with boldness, and centre our customers in every decision. We don't just move money, we strengthen families, fuel dreams, and redefine what's possible for the communities we serve.
                    </p>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- Our Values -->
<section class="py-20 bg-white">
    <div class="container mx-auto max-w-3xl px-4 sm:px-6 lg:px-8">
        <div class="mb-16">
            <p class="text-xs font-semibold uppercase tracking-wider mb-2" style="color: #072538; font-family: 'Red Hat Display', sans-serif;">Why Choose Us</p>
            <h2 class="text-3xl md:text-4xl text-cyan-500">Our Values</h2>
            <p class="text-gray-600 mt-4 max-w-2xl text-sm">The values that guide every transfer, every decision, and every relationship we build.</p>
        </div>

        <div class="space-y-6">
            <!-- Value 1 -->
            <div class="bg-gray-50 p-8 rounded-lg">
                <div class="flex items-start gap-4 mb-4">
                    <img src="/images/img4.png" alt="We are one" class="w-10 h-10 flex-shrink-0">
                </div>
                <h4 class="text-xl font-bold text-gray-900 mb-2">We are one</h4>
                <p class="text-gray-600 text-sm leading-relaxed">Together, we create a culture of respect, collaboration, and shared success. Because progress happens when we move as one.</p>
            </div>

            <!-- Value 2 -->
            <div class="bg-gray-50 p-8 rounded-lg">
                <div class="flex items-start gap-4 mb-4">
                    <img src="/images/img3.png" alt="Exemplify Authenticity" class="w-10 h-10 flex-shrink-0">
                </div>
                <h4 class="text-xl font-bold text-gray-900 mb-2">Exemplify Authenticity</h4>
                <p class="text-gray-600 text-sm leading-relaxed">We do what we say. Integrity guides every choice, ensuring transparency and accountability in all we do.</p>
            </div>

            <!-- Value 3 -->
            <div class="bg-gray-50 p-8 rounded-lg">
                <div class="flex items-start gap-4 mb-4">
                    <img src="/images/img2.png" alt="Performance Driven" class="w-10 h-10 flex-shrink-0">
                </div>
                <h4 class="text-xl font-bold text-gray-900 mb-2">Performance Driven</h4>
                <p class="text-gray-600 text-sm leading-relaxed">We reward excellence, push boundaries, and deliver results that matter, for our customers and our team.</p>
            </div>

            <!-- Value 4 -->
            <div class="bg-gray-50 p-8 rounded-lg">
                <div class="flex items-start gap-4 mb-4">
                    <img src="/images/img1.png" alt="Above and Beyond" class="w-10 h-10 flex-shrink-0">
                </div>
                <h4 class="text-xl font-bold text-gray-900 mb-2">Above and Beyond</h4>
                <p class="text-gray-600 text-sm leading-relaxed">We dream big, act boldly, and build solutions that exceed expectations.</p>
            </div>

            <!-- Value 5 -->
            <div class="bg-gray-50 p-8 rounded-lg">
                <div class="flex items-start gap-4 mb-4">
                    <img src="/images/img5.png" alt="Customer Heartbeat" class="w-10 h-10 flex-shrink-0">
                </div>
                <h4 class="text-xl font-bold text-gray-900 mb-2">Customer Heartbeat</h4>
                <p class="text-gray-600 text-sm leading-relaxed">Our customers inspire us. We listen, adapt, and innovate to meet their needs, because their success is ours.</p>
            </div>
        </div>
    </div>
</section>

<!-- Our Experience Section -->
<section class="py-20 bg-white">
    <div class="container mx-auto max-w-3xl px-4 sm:px-6 lg:px-8">
        <div class="mb-16">
            <p class="text-xs font-semibold uppercase tracking-wider mb-2" style="color: #072538; font-family: 'Red Hat Display', sans-serif;">Our Experience</p>
            <h2 class="text-3xl md:text-4xl text-cyan-500">Our Experience</h2>
            <p class="text-gray-600 mt-4 max-w-2xl text-sm">Helping families send money home affordably and efficiently for over a decade.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Employee Experience Card -->
            <div class="bg-white border border-gray-200 p-8 rounded-lg text-center">
                <div class="flex justify-center mb-6">
                    <img src="/images/img4.png" alt="Employee Experience" class="w-12 h-12">
                </div>
                <p class="text-gray-600 text-sm mb-2">Employee Experience:</p>
                <h3 class="text-3xl font-bold text-gray-900">100+ years</h3>
            </div>

            <!-- Countries We Serve Card -->
            <div class="bg-white border border-gray-200 p-8 rounded-lg text-center">
                <div class="flex justify-center mb-6">
                    <img src="/images/img6.png" alt="Countries we serve" class="w-12 h-12">
                </div>
                <p class="text-gray-600 text-sm mb-2">Countries we serve:</p>
                <h3 class="text-3xl font-bold text-gray-900">30+ Countries</h3>
            </div>
        </div>
    </div>
</section>

<!-- Join Our Team Section -->
<section class="py-20 bg-white">
    <div class="container mx-auto max-w-3xl px-4 sm:px-6 lg:px-8">
        <div class="mb-16">
            <p class="text-xs font-semibold uppercase tracking-wider mb-2" style="color: #072538; font-family: 'Red Hat Display', sans-serif;">Career</p>
            <h2 class="text-3xl md:text-4xl text-cyan-500">Join Our Team</h2>
            <p class="text-gray-600 mt-4 max-w-2xl text-sm">Be Part of a Purpose-Driven FinTech Journey.</p>
        </div>

        <div class="space-y-6">
            <!-- Job Vacancies Card -->
            <div class="bg-blue-50 p-8 rounded-lg border border-blue-100 min-h-72 relative overflow-hidden">
                <div class="relative z-10">
                    <h3 class="text-2xl font-bold text-blue-900 mb-2">Job Vacancies</h3>
                    <p class="text-gray-700 text-sm mb-6">Your Skills, Our Mission.<br>Let's Grow Together.</p>
                    <a href="#" class="inline-block px-6 py-2 rounded-lg font-semibold text-white transition mt-16" style="background-color: #072538;" onmouseover="this.style.backgroundColor='#051d2a'" onmouseout="this.style.backgroundColor='#072538'">
                        Apply Now
                    </a>
                </div>
                <!-- Image with gradient fade -->
                <div class="absolute -bottom-12 -right-4 w-96 h-full flex items-end justify-end">
                    <div class="relative w-72 h-72">
                        <img src="/images/img7.png" alt="Job Vacancies" class="w-full h-full object-contain pb-4 pr-4">
                        <div class="absolute inset-0 bg-gradient-to-r from-blue-50 to-transparent"></div>
                        <div class="absolute inset-0 bg-gradient-to-r from-blue-50 to-transparent"></div>
                    </div>
                </div>
            </div>

            <!-- Become an Agent Card -->
            <div class="bg-amber-50 p-8 rounded-lg border border-amber-100 min-h-72 relative overflow-hidden">
                <div class="relative z-10">
                    <h3 class="text-2xl font-bold text-amber-900 mb-2">Become an Agent</h3>
                    <p class="text-gray-700 text-sm mb-6">Earn more while serving your<br>community.</p>
                    <a href="#" class="inline-block px-6 py-2 rounded-lg font-semibold text-white transition mt-16" style="background-color: #6B4423;" onmouseover="this.style.backgroundColor='#523330'" onmouseout="this.style.backgroundColor='#6B4423'">
                        Apply Now
                    </a>
                </div>
                <!-- Image with gradient fade -->
                <div class="absolute -bottom-12 -right-4 w-96 h-full flex items-end justify-end">
                    <div class="relative w-72 h-72">
                        <img src="/images/img8.png" alt="Become an Agent" class="w-full h-full object-contain pb-4 pr-4">
                          <div class="absolute inset-0 bg-gradient-to-r from-amber-50 to-transparent"></div>
                        <div class="absolute inset-0 bg-gradient-to-r from-amber-50 to-transparent"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@include('components.cta-section')

@include('components.shared-footer')

@endsection