<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('banks', function (Blueprint $table) {
            $table->id();
            $table->string('country'); // e.g., 'Bangladesh', 'Pakistan'
            $table->enum('payout_type', ['Bank Transfer', 'Mobile Wallet', 'Cash Pickup']); // Payout type
            $table->string('bank_name'); // Bank/service name
            $table->string('country_code')->nullable(); // e.g., 'BD', 'PK'
            $table->string('currency_code')->nullable(); // e.g., 'BDT', 'PKR'
            $table->timestamps();
            
            // Indexes for faster queries
            $table->index('country');
            $table->index('payout_type');
            $table->index(['country', 'payout_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('banks');
    }
};
