<?php

namespace App\Http\Controllers;

use App\Models\Bank;
use Illuminate\Http\Request;

class BankController extends Controller
{
    /**
     * Get all countries with auto-complete
     */
    public function searchCountries(Request $request)
    {
        $query = $request->input('q', '');
        
        $countries = Bank::where('country', 'LIKE', '%' . $query . '%')
            ->select('country', 'country_code')
            ->distinct()
            ->orderBy('country')
            ->limit(20)
            ->get();
        
        return response()->json([
            'success' => true,
            'data' => $countries,
        ]);
    }
    
    /**
     * Get payout types for a country
     */
    public function getPayoutTypes($country)
    {
        $types = Bank::where('country', $country)
            ->select('payout_type')
            ->distinct()
            ->orderBy('payout_type')
            ->get()
            ->pluck('payout_type');
        
        return response()->json([
            'success' => true,
            'data' => $types,
        ]);
    }
    
    /**
     * Get banks for a country and payout type
     */
    public function getBanks(Request $request)
    {
        $country = $request->input('country');
        $payoutType = $request->input('payout_type');
        
        if (!$country || !$payoutType) {
            return response()->json([
                'success' => false,
                'message' => 'Country and payout type are required',
            ], 400);
        }
        
        $banks = Bank::where('country', $country)
            ->where('payout_type', $payoutType)
            ->select('bank_name', 'currency_code')
            ->orderBy('bank_name')
            ->get();
        
        return response()->json([
            'success' => true,
            'country' => $country,
            'payout_type' => $payoutType,
            'data' => $banks,
        ]);
    }
}
